#include"frogger.hpp"
using namespace std;

// Constructor:
FROGGER::FROGGER(){
  int i;
  diver1=diver2=0;
  swap1 = 0;
  swap2 = -50;
  sink1=1.;
  sink2=1.;
  rise1=0;
  rise2=0;
  dive1 = 1;
  dive2 = 0;
  sx = 0.0;
  sface = 1.;
  base=(int*)malloc(5*sizeof(int));
  for (int i = 0; i < 5; i++) base[i] = 0;
  sphase = 0.;
  maxy=-99;
  timer=99;
  lives=4;
  score=0;
  level=1;
  splat = 0;
  srand(time(NULL));//(unsigned int)ran1);
  difficulty = 5.0;
  x = 0.5;
  y = 0.275;
  // TURTLES:
  t1x = (double*)malloc(5*sizeof(double));
  t2x = (double*)malloc(5*sizeof(double));
  // LOGS:
  l1x = (double*)malloc(5*sizeof(double));
  l2x = (double*)malloc(5*sizeof(double));
  l3x = (double*)malloc(5*sizeof(double));
  for (int i = 0; i < 5; i++) {
      t1x[i] = 0.0;
      t2x[i] = 0.0;
      l1x[i] = 0.0;
      l2x[i] = 0.0;
      l3x[i] = 0.0;
  }
  for (i=0; i<5; i++){
      l1x[i] = i*0.23;
      l2x[i] = i*0.23;
  }
  for (i=0; i<4; i++){
      l3x[i] = i*0.2875;
  }
  for (i=0; i<4; i++){
      t1x[i] = i*0.275;
      t2x[i] = i*0.275;
  }
  t1y = 0.625;
  t2y = 0.725;
  l1y = 0.575;
  l2y = 0.675;
  l3y = 0.775;

  // CARS:
  c1x = (double*)malloc(4*sizeof(double));
  c2x = (double*)malloc(4*sizeof(double));
  c3x = (double*)malloc(4*sizeof(double));
  c4x = (double*)malloc(4*sizeof(double));
  for (int i = 0; i < 4; i++) {
      c1x[i] = 0.0;
      c2x[i] = 0.0;
      c3x[i] = 0.0;
      c4x[i] = 0.0;
  }
  c1x[0] = 0.0;
  c1x[1] = 0.275;
  c1x[2] = 2*0.275;
  c1x[3] = 3*0.275;
  c2x[0] = 0.0;
  c2x[1] = 0.275;
  c2x[2] = 2*0.275;
  c2x[3] = 3*0.275;
  c3x[0] = 0.0;
  c3x[1] = 0.275;
  c3x[2] = 2*0.275;
  c3x[3] = 3*0.275;
  c4x[0] = 0.0;
  c4x[1] = 0.275;
  c4x[2] = 2*0.275;
  c4x[3] = 3*0.275;
  c1y = 0.325;
  c2y = 0.375;
  c3y = 0.425;
  c4y = 0.475;
  face = UP;
}
// Destructor:
FROGGER::~FROGGER(){
}

void FROGGER::DrawSnake(double x,double y){
  int i=0;
  //x = 0.5;
  //y = 0.5;
  sphase += 0.01;
  if (sphase>2.*pi) sphase = 0.;
  for (i=0; i<60; i++){
      if (i%3==0) glColor3f(1.,0.5,0.);
      else        glColor3f(0.0,0.0,0.);
      splatcircle(0.003,x+sface*0.001*i,y+0.007*cos(sphase + i*100./(pi)),0.);
  }
}
void FROGGER::Snakes(){
  sx += sface*0.00075*difficulty;
  //if (sx>1.) sx = -0.06;
  if (sx>1. && sface>0){
     sface = -sface;
     sx = 1.06;
  }
  if (sx<0.0 && sface<0){
     sface = -sface;
     sx = -0.06;
  }
  DrawSnake(sx,0.525);
  if (y>0.5 && y<0.55){
     if (sface==1){
        if (x<sx+0.063+0.025 && x+0.025>sx) Splat();
     }
     else{
        if (x+0.025>sx-0.063 && x-0.025<sx) Splat();
     }
  }
}

void FROGGER::Splat(){
  splat = 1;
  // MAKE BLOOD
  glColor3f(1.,0.,0.);
  splatcircle(0.035,x,y,0.0);
  Frog();
}

void FROGGER::DrawTurtle(double x,double y,int face,int dive,double sink){
  if (dive==0){
     glColor3f(0.,1.,0.);
     circle(0.007,x+face*0.02,y,0.);
     glColor3f(0.,1.,0.);
     circle(0.005,x+0.01,y+0.01,0.);
     glColor3f(0.,1.,0.);
     circle(0.005,x-0.01,y+0.01,0.);
     glColor3f(0.,1.,0.);
     circle(0.005,x+0.01,y-0.01,0.);
     glColor3f(0.,1.,0.);
     circle(0.005,x-0.01,y-0.01,0.);
     glColor3f(1.0,0.2,0.2);
     oval(0.02,0.01,x,y,0.);
  }
  else if (dive==1){
     glColor3f(0.,1.,0.);
     circle(0.007*sink,x+face*0.02,y,0.);
     glColor3f(0.,1.,0.);
     circle(0.005*sink,x+0.01,y+0.01,0.);
     glColor3f(0.,1.,0.);
     circle(0.005*sink,x-0.01,y+0.01,0.);
     glColor3f(0.,1.,0.);
     circle(0.005*sink,x+0.01,y-0.01,0.);
     glColor3f(0.,1.,0.);
     circle(0.005*sink,x-0.01,y-0.01,0.);

     glColor3f(0.0,0.0,1.0);
     oval_nooutline(0.02,0.01,x,y,0.);
     glColor3f(1.0,0.2,0.2);
     oval(0.02*sink,0.01*sink,x,y,0.);
  }
  else if (dive==2){
     glColor3f(0.,0.5,1.);
     circle(0.007/2.,x+face*0.02,y,0.);
     glColor3f(0.,0.5,1.);
     circle(0.005/2.,x+0.01,y+0.01,0.);
     glColor3f(0.,0.5,1.);
     circle(0.005/2.,x-0.01,y+0.01,0.);
     glColor3f(0.,0.5,1.);
     circle(0.005/2.,x+0.01,y-0.01,0.);
     glColor3f(0.,0.5,1.);
     circle(0.005/2.,x-0.01,y-0.01,0.);

     //glColor3f(0.0,1.0,1.0);
     //oval_nooutline(0.02,0.01,x,y,0.);
     glColor3f(0.0,0.5,1.0);
     oval(0.02/2.,0.01/2.,x,y,0.);
  }
}

int FROGGER::Turtles(){
  int i,j,turtle,dive;
  double sink;

  if (level<1){
     swap1=dive1=dive2=0;
     swap2=-50;
  }

  // FIRST GROUP OF TURTLES DIVING:
  if (dive1==2){
     swap1++;
     if (swap1==1000){
        dive1=1;
        swap1=0;
     }
  }
  if (dive1==0){
     swap1++;
     if (swap1==1000){
        dive1=1;
        swap1=0;
     }
  }
  if (dive1==1){
     swap1++;
     if (!rise1) sink1-=0.0005;
     else        sink1+=0.0005;
     if (swap1==1000 && rise1==0){
        swap1 = 0;
        rise1 = 1;
        dive1 = 2;
     }
     else if (swap1==1000 && rise1==1){
        swap1 = 0;
        rise1 = 0;
        dive1 = 0;
        diver1 = (int)(4.*rand()/RAND_MAX);
        if (diver1==4) diver1 = 0;
     }
  }
  // SECOND GROUP OF TURTLES DIVING:
  if (dive2==2){
     swap2++;
     if (swap2==1000){
        dive2=1;
        swap2=0;
     }
  }
  if (dive2==0){
     swap2++;
     if (swap2>=1000){
        dive2=1;
        swap2=0;
     }
  }
  if (dive2==1){
     swap2++;
     if (!rise2) sink2-=0.0005;
     else        sink2+=0.0005;
     if (swap2==1000 && rise2==0){
        swap2 = 0;
        rise2 = 1;
        dive2 = 2;
     }
     else if (swap2==1000 && rise2==1){
        swap2 = 0;
        rise2 = 0;
        dive2 = 0;
        diver2 = (int)(4.*rand()/RAND_MAX);
        if (diver2==4) diver2 = 0;
     }
  }


  turtle=0;
  for (i=0; i<4; i++){
      if (i==diver1){
         dive=dive1;
         sink=sink1;
      }
      else{
         dive=0;
         sink=1.;
      }
      t1x[i] += 0.0005*difficulty;
      if (t1x[i]>1.) t1x[i] = -0.11;
      for (j=0; j<3; j++){
         DrawTurtle(t1x[i]+j*0.055,t1y,1,dive,sink);
      }
      // IS FROG ON TURTLE?
      if (y>0.6 && y<0.65){
         if (x<t1x[i]+0.137 && x>t1x[i]-0.02){
            turtle=1;
            if (dive==2) turtle=0;
            // IF FROG ON TURTLE, MOVE FROG
            if (x<=0.975)
               x += 0.0005*difficulty;
         }
      }
  }

  for (i=0; i<4; i++){
      if (i==diver2){
         dive=dive2;
         sink=sink2;
      }
      else{
         dive=0;
         sink=1.;
      }
      t2x[i] -= 0.0005*difficulty;
      if (t2x[i]<-0.11) t2x[i] = 1.;
      for (j=0; j<2; j++){
         DrawTurtle(t2x[i]+j*0.07,t2y,-1,dive,sink);
      }
      // IS FROG ON TURTLE?
      if (y>0.7 && y<0.75){
         if (x<t2x[i]+0.09 && x>t2x[i]-0.02-0.007){
            turtle=1;
            if (dive==2) turtle=0;
            // IF FROG ON TURTLE, MOVE FROG
            if (x>=0.025)
               x -= 0.0005*difficulty;
         }
      }
  }


  return turtle;
}

int FROGGER::Logs(){
  log = 0;
  int i;
  // LOG 1
  for (i=0; i<5; i++){
      l1x[i] += 0.00035*difficulty;
      if (l1x[i]>1.05) l1x[i] = -0.1;
      glColor3f(0.7,0.4,0.3);
      circle(0.02,l1x[i]-0.02,l1y,0.);
      glColor3f(0.7,0.4,0.3);
      circle(0.02,l1x[i]+0.07,l1y,0.);
      glColor3f(0.7,0.4,0.3);
      glBegin(GL_QUADS);
        glVertex3f(l1x[i]-0.02,l1y-0.02,0.);
        glVertex3f(l1x[i]+0.07,l1y-0.02,0.);
        glVertex3f(l1x[i]+0.07,l1y+0.02,0.);
        glVertex3f(l1x[i]-0.02,l1y+0.02,0.);
      glEnd();
      glColor3f(0.0,0.0,0.0);
      glBegin(GL_LINES);
        glVertex3f(l1x[i]-0.02,l1y-0.02,0.);
        glVertex3f(l1x[i]+0.07,l1y-0.02,0.);
        glVertex3f(l1x[i]+0.07,l1y+0.02,0.);
        glVertex3f(l1x[i]-0.02,l1y+0.02,0.);
      glEnd();
      glColor3f(0.7,0.4,0.3);
      circle(0.02,l1x[i]+0.07,l1y,0.);
      glColor3f(0.7,0.5,0.4);
      circle(0.01,l1x[i]+0.07,l1y,0.);
      glColor3f(0.7,0.5,0.4);
      circle(0.005,l1x[i]+0.07,l1y,0.);

      // IS FROG ON LOG?
      if (y>0.55 && y<0.6){
         if (x+0.025>l1x[i]-0.03 && x-0.025<l1x[i]+0.07){
            log=1;
            // IF FROG ON LOG, MOVE FROG
            if (x<=0.975)
               x += 0.00035*difficulty;
         }
      }
  }
  // LOG 2
  for (i=0; i<5; i++){
      l2x[i] -= 0.00035*difficulty;
      if (l2x[i]<-0.1) l2x[i] = 1.05;
      glColor3f(0.7,0.4,0.3);
      circle(0.02,l2x[i]-0.02,l2y,0.);
      glColor3f(0.7,0.4,0.3);
      circle(0.02,l2x[i]+0.07,l2y,0.);
      glColor3f(0.7,0.4,0.3);
      glBegin(GL_QUADS);
        glVertex3f(l2x[i]-0.02,l2y-0.02,0.);
        glVertex3f(l2x[i]+0.07,l2y-0.02,0.);
        glVertex3f(l2x[i]+0.07,l2y+0.02,0.);
        glVertex3f(l2x[i]-0.02,l2y+0.02,0.);
      glEnd();
      glColor3f(0.0,0.0,0.0);
      glBegin(GL_LINES);
        glVertex3f(l2x[i]-0.02,l2y-0.02,0.);
        glVertex3f(l2x[i]+0.07,l2y-0.02,0.);
        glVertex3f(l2x[i]+0.07,l2y+0.02,0.);
        glVertex3f(l2x[i]-0.02,l2y+0.02,0.);
      glEnd();
      glColor3f(0.7,0.4,0.3);
      circle(0.02,l2x[i]-0.03,l2y,0.);
      glColor3f(0.7,0.5,0.4);
      circle(0.01,l2x[i]-0.03,l2y,0.);
      glColor3f(0.7,0.5,0.4);
      circle(0.005,l2x[i]-0.03,l2y,0.);
      // IS FROG ON LOG?
      if (y>0.65 && y<0.7){
         if (x+0.025>l2x[i]-0.03 && x-0.025<l2x[i]+0.07){
            log=1;
            // IF FROG ON LOG, MOVE FROG
            if (x>=0.025)
               x -= 0.00035*difficulty;
         }
      }
  }
  // LOG 3
  for (i=0; i<4; i++){
      l3x[i] += 0.00055*difficulty;
      if (l3x[i]>1.05) l3x[i] = -0.1;
      glColor3f(0.7,0.4,0.3);
      circle(0.02,l3x[i]-0.02,l3y,0.);
      glColor3f(0.7,0.4,0.3);
      circle(0.02,l3x[i]+0.07,l3y,0.);
      glColor3f(0.7,0.4,0.3);
      glBegin(GL_QUADS);
        glVertex3f(l3x[i]-0.02,l3y-0.02,0.);
        glVertex3f(l3x[i]+0.07,l3y-0.02,0.);
        glVertex3f(l3x[i]+0.07,l3y+0.02,0.);
        glVertex3f(l3x[i]-0.02,l3y+0.02,0.);
      glEnd();
      glColor3f(0.0,0.0,0.0);
      glBegin(GL_LINES);
        glVertex3f(l3x[i]-0.02,l3y-0.02,0.);
        glVertex3f(l3x[i]+0.07,l3y-0.02,0.);
        glVertex3f(l3x[i]+0.07,l3y+0.02,0.);
        glVertex3f(l3x[i]-0.02,l3y+0.02,0.);
      glEnd();
      glColor3f(0.7,0.4,0.3);
      circle(0.02,l3x[i]+0.07,l3y,0.);
      glColor3f(0.7,0.5,0.4);
      circle(0.01,l3x[i]+0.07,l3y,0.);
      glColor3f(0.7,0.5,0.4);
      circle(0.005,l3x[i]+0.07,l3y,0.);
      // IS FROG ON LOG?
      if (y>0.75 && y<0.8){
         if (x+0.025>l3x[i]-0.03 && x-0.025<l3x[i]+0.07){
            log=1;
            // IF FROG ON LOG, MOVE FROG
            if (x<=0.975)
               x += 0.00055*difficulty;
         }
      }
  }
  //if (log==0 && y>0.6 && y<0.75){ 
     //Splat();
  //}
  return log;
}
void FROGGER::DrawCar(double x,double y){
  glBegin(GL_QUADS);
    glVertex3f(x-0.05,y-0.015,0.);
    glVertex3f(x-0.05,y+0.01,0.);
    glVertex3f(x+0.05,y+0.01,0.);
    glVertex3f(x+0.05,y-0.015,0.);
  glEnd();
  glBegin(GL_POLYGON);
    glVertex3f(x-0.05,y-0.015,0.);
    glVertex3f(x-0.03,y+0.025,0.);
    glVertex3f(x+0.03,y+0.025,0.);
    glVertex3f(x+0.05,y-0.015,0.);
  glEnd();
  glColor3f(0.,0.,0.);
  circle(0.012,x-0.027,y-0.01,0.);
  circle(0.012,x+0.027,y-0.01,0.);
  glColor3f(0.8,0.8,0.8);
  circle(0.007,x-0.027,y-0.01,0.);
  glColor3f(0.8,0.8,0.8);
  circle(0.007,x+0.027,y-0.01,0.);
}
void FROGGER::Cars(){
  int i,j,k;
  double tx,ty;
  // CAR1
  for (i=0; i<4; i++){
      c1x[i] += 0.0001*difficulty;
      if (c1x[i]>1.05) c1x[i] = -0.05;
      glColor3f(1.0,0.,0.);
      DrawCar(c1x[i],c1y);
      // CHECK IF DEAD
      if (y>0.3 && y<0.35){
         if (x+0.025>c1x[i]-0.05 && x-0.025<c1x[i]+0.05)
            Splat();
      }
  }
  // CAR2
  for (i=0; i<4; i++){
      c2x[i] -= 0.0002*difficulty;
      if (c2x[i]<-0.05) c2x[i] = 1.05;
      glColor3f(1.0,0.,1.);
      DrawCar(c2x[i],c2y);
      // CHECK IF DEAD
      if (y>0.35 && y<0.4){
         if (x+0.025>c2x[i]-0.05 && x-0.025<c2x[i]+0.05)
            Splat();
      }
  }
  // CAR3
  for (i=0; i<4; i++){
      c3x[i] += 0.0004*difficulty;
      if (c3x[i]>1.05) c3x[i] = -0.05;
      glColor3f(0.0,1.,1.);
      DrawCar(c3x[i],c3y);
      // CHECK IF DEAD
      if (y>0.4 && y<0.45){
         if (x+0.025>c3x[i]-0.05 && x-0.025<c3x[i]+0.05)
            Splat();
      }
  }
  // CAR4
  for (i=0; i<4; i++){
      c4x[i] -= 0.0003*difficulty;
      if (c4x[i]<-0.05) c4x[i] = 1.05;
      glColor3f(1.0,1.0,0.);
      DrawCar(c4x[i],c4y);
      // CHECK IF DEAD
      if (y>0.45 && y<0.5){
         if (x+0.025>c4x[i]-0.05 && x-0.025<c4x[i]+0.05)
            Splat();
      }
  }
}

void FROGGER::splatcircle(double r,double x,double y,double z){
  double theta,xx,yy;
  glBegin(GL_POLYGON);
  for (theta=0.; theta<=pi/2.; theta+=0.05){
      xx = r*cos(theta);
      yy = r*sin(theta);
      glVertex3f(x+xx,y+yy,z);
      glVertex3f(x+xx,y-yy,z);
      glVertex3f(x-xx,y+yy,z);
      glVertex3f(x-xx,y-yy,z);
  }
  glEnd();
}

void FROGGER::makex(double r,double x,double y,double z){
  double xx,yy;
  xx = yy = r;
  glBegin(GL_LINES);
      glVertex3f(x+xx,y+yy,z);
      glVertex3f(x-xx,y-yy,z);
      glVertex3f(x-xx,y+yy,z);
      glVertex3f(x+xx,y-yy,z);
  glEnd();
}
void FROGGER::oval_nooutline(double r1,double r2,double x,double y,double z){
  double theta,xx,yy;
  glBegin(GL_POLYGON);
  for (theta=0.; theta<=pi/2.; theta+=0.05){
      xx = r1*cos(theta);
      yy = r2*sin(theta);
      glVertex3f(x+xx,y+yy,z);
      glVertex3f(x+xx,y-yy,z);
      glVertex3f(x-xx,y+yy,z);
      glVertex3f(x-xx,y-yy,z);
  }
  glEnd();
}
void FROGGER::oval(double r1,double r2,double x,double y,double z){
  double theta,xx,yy;
  glBegin(GL_POLYGON);
  for (theta=0.; theta<=pi/2.; theta+=0.05){
      xx = r1*cos(theta);
      yy = r2*sin(theta);
      glVertex3f(x+xx,y+yy,z);
      glVertex3f(x+xx,y-yy,z);
      glVertex3f(x-xx,y+yy,z);
      glVertex3f(x-xx,y-yy,z);
  }
  glEnd();
  glBegin(GL_POINTS);
  glColor3f(0.,0.,0.);
  for (theta=0.; theta<=pi/2.; theta+=0.05){
      xx = r1*cos(theta);
      yy = r2*sin(theta);
      glVertex3f(x+xx,y+yy,z);
      glVertex3f(x+xx,y-yy,z);
      glVertex3f(x-xx,y+yy,z);
      glVertex3f(x-xx,y-yy,z);
  }
  glEnd();
}


void FROGGER::circle(double r,double x,double y,double z){
  double theta,xx,yy;
  glBegin(GL_POLYGON);
  for (theta=0.; theta<=pi/2.; theta+=0.05){
      xx = r*cos(theta);
      yy = r*sin(theta);
      glVertex3f(x+xx,y+yy,z);
      glVertex3f(x+xx,y-yy,z);
      glVertex3f(x-xx,y+yy,z);
      glVertex3f(x-xx,y-yy,z);
  }
  glEnd();
  glBegin(GL_POINTS);
  glColor3f(0.,0.,0.);
  for (theta=0.; theta<=pi/2.; theta+=0.05){
      xx = r*cos(theta);
      yy = r*sin(theta);
      glVertex3f(x+xx,y+yy,z);
      glVertex3f(x+xx,y-yy,z);
      glVertex3f(x-xx,y+yy,z);
      glVertex3f(x-xx,y-yy,z);
  }
  glEnd();
}

void FROGGER::Frog(){
  double r=0.009;
  double sgx,sgy;

  switch(face){
    case LEFT:
      // LEGS (BACK)
      glColor3f(0.0,1.0,0.5);
      circle(r,x+2*r,y+2*r,0.0);
      glColor3f(0.0,1.0,0.5);
      circle(r,x+2*r,y-2*r,0.0);
      // LEGS (FRONT)
      glColor3f(0.0,1.0,0.5);
      circle(r,x-1.3*r,y-2.0*r,0.0);
      glColor3f(0.0,1.0,0.5);
      circle(r,x-1.3*r,y+2.0*r,0.0);
      // BODY
      glColor3f(0.0,1.0,0.5);
      circle(0.025,x,y,0.0);
      // EYES
      if (!splat){
         glColor3f(1.0,1.0,1.0);
         circle(r,x-r,y-r,0.0);
         glColor3f(1.0,1.0,1.0);
         circle(r,x-r,y+r,0.0);
         glColor3f(0.0,0.0,0.0);
         circle(r/3,x-r*1.4,y-0.95*r,0.0);
         glColor3f(0.0,0.0,0.0);
         circle(r/3,x-r*1.4,y+r*0.95,0.0);
      }
      else {
         glColor3f(0.0,0.0,0.0);
         makex(r/2,x-r*1.4,y-0.95*r,0.0);
         glColor3f(0.0,0.0,0.0);
         makex(r/2,x-r*1.4,y+r*0.95,0.0);
      }
    break;
    case RIGHT:
      // LEGS (BACK)
      glColor3f(0.0,1.0,0.5);
      circle(r,x-2*r,y+2*r,0.0);
      glColor3f(0.0,1.0,0.5);
      circle(r,x-2*r,y-2*r,0.0);
      // LEGS (FRONT)
      glColor3f(0.0,1.0,0.5);
      circle(r,x+1.3*r,y-2.0*r,0.0);
      glColor3f(0.0,1.0,0.5);
      circle(r,x+1.3*r,y+2.0*r,0.0);
      // BODY
      glColor3f(0.0,1.0,0.5);
      circle(0.025,x,y,0.0);
      // EYES
      if (!splat){
         glColor3f(1.0,1.0,1.0);
         circle(r,x+r,y-r,0.0);
         glColor3f(1.0,1.0,1.0);
         circle(r,x+r,y+r,0.0);
         glColor3f(0.0,0.0,0.0);
         circle(r/3,x+r*1.4,y-0.95*r,0.0);
         glColor3f(0.0,0.0,0.0);
         circle(r/3,x+r*1.4,y+r*0.95,0.0);
      }
      else {
         glColor3f(0.0,0.0,0.0);
         makex(r/2,x+r*1.4,y-0.95*r,0.0);
         glColor3f(0.0,0.0,0.0);
         makex(r/2,x+r*1.4,y+r*0.95,0.0);
      }
    break;
    case UP:
      // LEGS (BACK)
      glColor3f(0.0,1.0,0.5);
      circle(r,x-2*r,y-2*r,0.0);
      glColor3f(0.0,1.0,0.5);
      circle(r,x+2*r,y-2*r,0.0);
      // LEGS (FRONT)
      glColor3f(0.0,1.0,0.5);
      circle(r,x-2.0*r,y+1.3*r,0.0);
      glColor3f(0.0,1.0,0.5);
      circle(r,x+2.0*r,y+1.3*r,0.0);
      // BODY
      glColor3f(0.0,1.0,0.5);
      circle(0.025,x,y,0.0);
      // EYES
      if (!splat){
         glColor3f(1.0,1.0,1.0);
         circle(r,x-r,y+r,0.0);
         glColor3f(1.0,1.0,1.0);
         circle(r,x+r,y+r,0.0);
         glColor3f(0.0,0.0,0.0);
         circle(r/3,x-r*.95,y+1.4*r,0.0);
         glColor3f(0.0,0.0,0.0);
         circle(r/3,x+r*.95,y+r*1.4,0.0);
      }
      else{
         glColor3f(0.0,0.0,0.0);
         makex(r/2,x-r*.95,y+1.4*r,0.0);
         glColor3f(0.0,0.0,0.0);
         makex(r/2,x+r*.95,y+r*1.4,0.0);
      }
    break;
    case DOWN:
      // LEGS (BACK)
      glColor3f(0.0,1.0,0.5);
      circle(r,x-2*r,y+2*r,0.0);
      glColor3f(0.0,1.0,0.5);
      circle(r,x+2*r,y+2*r,0.0);
      // LEGS (FRONT)
      glColor3f(0.0,1.0,0.5);
      circle(r,x-2.0*r,y-1.3*r,0.0);
      glColor3f(0.0,1.0,0.5);
      circle(r,x+2.0*r,y-1.3*r,0.0);
      // BODY
      glColor3f(0.0,1.0,0.5);
      circle(0.025,x,y,0.0);
      // EYES
      if (!splat){
         glColor3f(1.0,1.0,1.0);
         circle(r,x-r,y-r,0.0);
         glColor3f(1.0,1.0,1.0);
         circle(r,x+r,y-r,0.0);
         glColor3f(0.0,0.0,0.0);
         circle(r/3,x-r*.95,y-1.4*r,0.0);
         glColor3f(0.0,0.0,0.0);
         circle(r/3,x+r*.95,y-r*1.4,0.0);
      }
      else{
         glColor3f(0.0,0.0,0.0);
         makex(r/2,x-r*.95,y-1.4*r,0.0);
         glColor3f(0.0,0.0,0.0);
         makex(r/2,x+r*.95,y-r*1.4,0.0);
      }
    break;
  }
  glFlush();
}

void FROGGER::Screen(){
  int i,j,tmpf;
  double tmpx,tmpy;
  glBegin(GL_QUADS);
    glColor3f(0.0,0.0,0.0);
    glVertex3f(0.0,0.0,0.0);
    glVertex3f(1.0,0.0,0.0);
    glVertex3f(1.0,0.25,0.0);
    glVertex3f(0.0,0.25,0.0);
    // GRASS
    glColor3f(0.0,1.0,0.0);
    glVertex3f(0.0,0.25,0.0);
    glVertex3f(1.0,0.25,0.0);
    glVertex3f(1.0,0.28,0.0);
    glVertex3f(0.0,0.28,0.0);
    // SIDEWALK
    glColor3f(1.0,1.0,1.0);
    glVertex3f(0.0,0.28,0.0);
    glVertex3f(1.0,0.28,0.0);
    glVertex3f(1.0,0.3,0.0);
    glVertex3f(0.0,0.3,0.0);
    // STREET
    glColor3f(0.2,0.2,0.2);
    glVertex3f(0.0,0.3,0.0);
    glVertex3f(1.0,0.3,0.0);
    glVertex3f(1.0,0.50,0.0);
    glVertex3f(0.0,0.50,0.0);
    // LINES IN STREET:
    glColor3f(1.0,1.0,1.0);
    for (i=0; i<10; i++){
        for (j=0; j<3; j++){
            glVertex3f(i*0.1+0.025,  0.345 + 0.05*j,0.0); 
            glVertex3f(i*0.1 + 0.075,0.345 + 0.05*j,0.0);
            glVertex3f(i*0.1+0.075,  0.35 + 0.05*j,0.0); 
            glVertex3f(i*0.1+0.025,  0.35 + 0.05*j,0.0);
        }
    }

    // SIDEWALK
    glColor3f(1.0,1.0,1.0);
    glVertex3f(0.0,0.50,0.0);
    glVertex3f(1.0,0.50,0.0);
    glVertex3f(1.0,0.52,0.0);
    glVertex3f(0.0,0.52,0.0);
    // GRASS
    glColor3f(0.0,1.0,0.0);
    glVertex3f(0.0,0.52,0.0);
    glVertex3f(1.0,0.52,0.0);
    glVertex3f(1.0,0.55,0.0);
    glVertex3f(0.0,0.55,0.0);
    // WATER
    glColor3f(0.0,0.0,1.0);
    glVertex3f(0.0,0.55,0.0);
    glVertex3f(1.0,0.55,0.0);
    glVertex3f(1.0,0.8,0.0);
    glVertex3f(0.0,0.8,0.0);
    // NOT BASE
    glColor3f(0.7,0.4,0.3);
    glVertex3f(0.0,0.8,0.0);
    glVertex3f(1.0,0.8,0.0);
    glVertex3f(1.0,0.87,0.0);
    glVertex3f(0.0,0.87,0.0);
    // BASE
    glColor3f(0.0,1.0,0.5);
    for (i=0; i<5; i++){
        glColor3f(0.0,1.0,0.5);
        glVertex3f(0.1+i*.18,0.8,0.0);
        glVertex3f(0.1+(i+0.5)*.18,0.8,0.0);
        glVertex3f(0.1+(i+0.5)*.18,0.85,0.0);
        glVertex3f(0.1+i*.18,0.85,0.0);
    }
    // BACK
    glColor3f(0.0,0.0,0.0);
    for (i=0; i<5; i++){
        glVertex3f(0,0.87,0.0);
        glVertex3f(0,1.0,0.0);
        glVertex3f(1,1.0,0.0);
        glVertex3f(1,0.87,0.0);
    }
  glEnd();
  // BASE LINES
  glBegin(GL_LINES);
    glColor3f(0.0,0.0,0.0);
    for (i=0; i<5; i++){
        glVertex3f(0.1+i*.18,0.8,0.0);
        glVertex3f(0.1+i*.18,0.85,0.0);
        glVertex3f(0.1+(i+0.5)*.18,0.8,0.0);
        glVertex3f(0.1+(i+0.5)*.18,0.85,0.0);
        glVertex3f(0.1+i*.18,0.85,0.0);
        glVertex3f(0.1+(i+0.5)*.18,0.85,0.0);
    }
    glVertex3f(0,0.8,0.0);
    glVertex3f(0.1,0.8,0.0);
    glVertex3f(1,0.8,0.0);
    glVertex3f(0.91,0.8,0.0);
  glEnd();
  glColor3f(1.,1,1.);
  DrawText(200,450,"FROGGER",1,1,1);
  DrawText(10,90,"LIVES:",1,1,1);
  DrawText(10,50,"LEVEL:",1,1,1);
  DrawText(10,10,"SCORE:",1,1,1);

  if (resettime){
     timer=60;
     resettime=0;
   }
  if (!splat) timer -= 0.003;
  if (timer<0.9){
     splat=1;
     //resettime=1;
  }
 
  DrawText(390,90,"TIME:",1,1,1);
  char*string;
  string = (char*)malloc(100*sizeof(char));
  itoa(lives,string,10);
  DrawText(150,90,string,1,1,1);
  itoa(level,string,10);
  DrawText(150,50,string,1,1,1);
  itoa(score,string,10);
  DrawText(150,10,string,1,1,1);
  int t = (int)timer;
  itoa(timer,string,10);
  DrawText(470,90,string,1,1,1);
  free(string);
  //DrawText(180,430,"",1,1,1);
}
void FROGGER::Base(){
  int i,tmpf,nbase,die=1;
  double tmpx,tmpy;
  if (y>0.8){
     for (i=0; i<5; i++){
         if (x+0.025<=0.1+(i+0.5)*.18 && x-0.025>=0.1+i*.18){
            if (base[i]){
               Splat();
               continue;
            }
            base[i]=1;
            die=0;
            score += 100;
            x = 0.1+.18*(i+0.25);
            y = 0.825;
            face = UP;
            Frog();
            x = 0.5;
            y = 0.275;
            maxy=-1;
            i=5;
         }
     }
     if (die) splat = 1;
  }
  for (i=0; i<5; i++){
      if (base[i]){
         tmpf = face;
         tmpx = x;
         tmpy = y;
         x = 0.1+.18*(i) + 0.045;
         y = 0.825;
         face = UP;
         Frog();
         glFlush();
         x = tmpx;
         y = tmpy;
         face = tmpf;
      }
  }
  // CHECK IF LEVEL COMPLETED:
  nbase=0;
  for (i=0; i<5; i++) nbase+=base[i];
  if (nbase==5){
     difficulty += 0.2;
     level++;
     score += (int)timer;
     resettime=1;
     for (i=0; i<5; i++) base[i] = 0;
  }
}

void
DrawText(GLint x, GLint y, char* s, GLfloat r, GLfloat g, GLfloat b)
{
    int lines;
    char* p;

    glMatrixMode(GL_PROJECTION);
     glPushMatrix();
     glLoadIdentity();
     glOrtho(0.0, glutGet(GLUT_WINDOW_WIDTH), 
	    0.0, glutGet(GLUT_WINDOW_HEIGHT), -1.0, 1.0);
     glMatrixMode(GL_MODELVIEW);
      glPushMatrix();
      glLoadIdentity();
      glColor3f(r,g,b);
      glRasterPos2i(x, y);
      for(p = s, lines = 0; *p; p++) {
	  if (*p == '\n') {
	      lines++;
	      glRasterPos2i(x, y-(lines*18));
	  }
	  //glutBitmapCharacter(GLUT_BITMAP_HELVETICA_18, *p);
	  glutBitmapCharacter(GLUT_BITMAP_TIMES_ROMAN_24, *p);
      }
      glPopMatrix();
     glMatrixMode(GL_PROJECTION);
     glPopMatrix();
     glMatrixMode(GL_MODELVIEW);
}
// FUNCTIONS TO TURN INT INTO STRING

/*size_t strlen(const char *string) {
        const char *s;

        s = string;
        while (*s)
                s++;
        return s - string;
}*/

char *strrev(char *str) {
        char *p1, *p2;

        if (!str || !*str)
                return str;

        for (p1 = str, p2 = str + strlen(str) - 1; p2 > p1; ++p1, --p2) {
                *p1 ^= *p2;
                *p2 ^= *p1;
                *p1 ^= *p2;
        }

        return str;
}

char *itoa(int n, char *s, int b) {
        static char digits[] = "0123456789abcdefghijklmnopqrstuvwxyz";
        int i=0, sign;

        if ((sign = n) < 0)
                n = -n;

        do {
                s[i++] = digits[n % b];
        } while ((n /= b) > 0);

        if (sign < 0)
                s[i++] = '-';
        s[i] = '\0';

        return strrev(s);
}
