#
# @BEGIN LICENSE
#
# mydft by Psi4 Developer, a plugin to:
#
# Psi4: an open-source quantum chemistry software package
#
# Copyright (c) 2007-2018 The Psi4 Developers.
#
# The copyrights for code used from other parties are included in
# the corresponding files.
#
# This file is part of Psi4.
#
# Psi4 is free software; you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, version 3.
#
# Psi4 is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License along
# with Psi4; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#
# @END LICENSE
#

import psi4
import psi4.driver.p4util as p4util
from psi4.driver.procrouting import proc_util
from psi4.driver.procrouting import proc

def run_mydft(name, **kwargs):
    r"""Function encoding sequence of PSI module and plugin calls so that
    mydft can be called via :py:func:`~driver.energy`. For post-scf plugins.

    >>> energy('mydft')

    """
    lowername = name.lower()
    kwargs = p4util.kwargs_lower(kwargs)

    # Your plugin's psi4 run sequence goes here

    # Compute a SCF reference, a wavefunction is return which holds the molecule used, orbitals
    # Fock matrices, and more
    #print('Attention! This SCF may be density-fitted.')
    #ref_wfn = kwargs.get('ref_wfn', None)
    #if ref_wfn is None:
    #    ref_wfn = psi4.driver.scf_helper(name, **kwargs)

    #func = psi4.core.get_option('MYDFT','FUNCTIONAL')
    #scf_molecule = kwargs.get('molecule', psi4.core.get_active_molecule())
    #base_wfn = psi4.core.Wavefunction.build(scf_molecule, psi4.core.get_global_option('BASIS'))
    #scf_wfn = proc.scf_wavefunction_factory(psi4.core.get_option('MYDFT', 'REFERENCE'), base_wfn, func)

    func = psi4.core.get_option('MYDFT','FUNCTIONAL')
    ref_molecule = kwargs.get('molecule', psi4.core.get_active_molecule())
    base_wfn = psi4.core.Wavefunction.build(ref_molecule, psi4.core.get_global_option('BASIS'))
    ref_wfn = proc.scf_wavefunction_factory(func, base_wfn, psi4.core.get_option('MYDFT', 'REFERENCE'))

    # Ensure IWL files have been written when not using DF/CD
    proc_util.check_iwl_file_from_scf_type(psi4.core.get_option('SCF', 'SCF_TYPE'), ref_wfn)

    # Call the Psi4 plugin
    # Please note that setting the reference wavefunction in this way is ONLY for plugins
    mydft_wfn = psi4.core.plugin('mydft.so', ref_wfn)

    return mydft_wfn


# Integration with driver routines
psi4.driver.procedures['energy']['mydft'] = run_mydft


def exampleFN():
    # Your Python code goes here
    pass
