% This Matlab script performs filtered back-projection on transmittance
% images taken within a full rotation of a sample.

clear Image_array BackProjArray;
%close all;

%=============================PARAMETERS===================================
dir = '.\';                 % name of folder
fn = 'trans_image_';        % file name root
fi = 1;                     % number of first image
li = 62;                    % number of last image
smf = 5;                    % smoothing factor (positive odd integer)
is = 0.35;                  % isosurface (0<=is<=1)
%==========================================================================

% Loading images into an array
Image_array(:,:,li-fi+1) = double(imread([dir,fn,int2str(li-fi+1),'.jpg']));
for i=1:(li-fi)
    Image_array(:,:,i)=double(imread([dir,fn,int2str(i),'.jpg']));
end
[y,x,n] = size(Image_array);
d_angle = 360/n;
theta = 0:d_angle:359;

N = 2*floor(x/(2*sqrt(2)) );
BackProjArray(N,N,y) = 0;

for Y = 1:y    
    % Back-projection calculation on Yth sinogram then reversely stacking
    % the reconstructed Yth layer under the (Y-1)th slide
    % The Yth sinogram is Image_array(Y,:,:)
    BackProjSing = iradon(squeeze(Image_array(Y,:,:)),theta,'spline','Hann');
    BackProjArray(:,:,y-Y+1) = BackProjSing(:,:);
end
BackProjArray = smooth3(BackProjArray,'box',smf); %Smoothening of reconstructed volume

%Rescale reconstructed data
mi=min(min(min(BackProjArray)));
ma=max(max(max(BackProjArray)));
ra=ma-mi;
BackProjArray=(BackProjArray-mi)/ra;

%Displaying isosurfaces and slices
%Figure 1: whole volume;
%Figure 2: posterior half only;
%Figure 3: slices taken at every 45 from 0 to 135
sreensize = get(0,'ScreenSize');
figure('Position',[10 sreensize(4)/2+30 sreensize(3)/2-20 sreensize(4)/2-110]);
p1 = patch(isosurface(BackProjArray,is));
p2 = patch(isocaps(BackProjArray,is));
isonormals(BackProjArray,p1);
set(p1,'FaceColor','red','EdgeColor','none');
set(p2,'FaceColor','red','EdgeColor','none','FaceLighting','none');
set(gcf, 'color', 'white');
view(-76,12);
box on;
lighting phong;
lightangle(-30,30);
camproj('perspective');
axis tight;
daspect([1,1,1]);
xlabel('x (pix)');
ylabel('y (pix)');
zlabel('z (pix)');


[xBPA,yBPA,zBPA] = size(BackProjArray);
BackProjArray_2=BackProjArray;
BackProjArray(1:xBPA,1:yBPA/2,:)=0;     % Eliminating pattern from the anterior half

figure('Position',[sreensize(3)/2+10 sreensize(4)/2+30 sreensize(3)/2-20 sreensize(4)/2-110]);
p1 = patch(isosurface(BackProjArray,is));
p2 = patch(isocaps(BackProjArray,is));
isonormals(BackProjArray,p1);
set(p1,'FaceColor','red','EdgeColor','none');
set(p2,'FaceColor','red','EdgeColor','none','FaceLighting','none');
set(gcf, 'color', 'white');
view(-76,12);
box on;
lighting phong;
lightangle(-30,0);
camproj('perspective');
axis tight;
daspect([1,1,1]);
xlabel('x (pix)');
ylabel('y (pix)');
zlabel('z (pix)');

figure('Position',[10 50 sreensize(3)/2-20 sreensize(4)/2-110]);
[X,Y,Z] = meshgrid(1:xBPA,1:yBPA,1:zBPA);
sf = surf(zeros(zBPA,xBPA));
rotate(sf,[1,0,0],90);
xd = get(sf,'XData');
yd = get(sf,'YData');
zd = get(sf,'ZData');
delete(sf);
yd=yd-min(min(yd))+1+yBPA/2;
zd=zd-min(min(zd))+1;
center=[xBPA/2,yBPA/2,0];
for i=0:45:135
    sfb = surf(xd,yd,zd);
    rotate(sfb,[0,0,1],i,center);
    xd1 = get(sfb,'XData');
    yd1 = get(sfb,'YData');
    zd1 = get(sfb,'ZData');
    h=slice(X,Y,Z,BackProjArray_2,xd1,yd1,zd1,'cubic');
    set(h,'FaceColor','flat','EdgeColor','flat');
    hold on
end
colormap(gray);
xlabel('x (pix)');
ylabel('y (pix)');
zlabel('z (pix)');
set(gcf, 'color', 'white');
axis tight;
box on;
grid off;
view(-33,23);
daspect([1,1,1]);